/////////////////////////////////////////////////////////////////////
//
// EPSNDISP.H
//
//   Line Display header file for OPOS Applications.
//
// Modification history
// ------------------------------------------------------------------
//
/////////////////////////////////////////////////////////////////////

#if !defined(EPSNDISP_H)
#define      EPSNDISP_H

#include "epson.h"

/////////////////////////////////////////////////////////////////////
// "ResultCodeExtended" Property Constants for Line Display
/////////////////////////////////////////////////////////////////////
const LONG OPOS_EDISP_TOOMANYWINDOWS	= 1 + DISPERREXT;	// 
const LONG OPOS_EDISP_TOOMANYDEFGLYPH	= 2 + DISPERREXT;	// 

/////////////////////////////////////////////////////////////////////
// DirectIO Method Constants
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////
// Command
const LONG DISP_DI_SYNC						= 0;
const LONG DISP_DI_OUTPUT_NORMAL			= 1;
const LONG DISP_DI_GRAPHIC					= 2;
const LONG DISP_DI_SETIMAGE					= 3;
const LONG DISP_DI_GETMODE					= 4;
const LONG DISP_DI_SETFONT					= 5;
const LONG DISP_DI_GW_STYLE					= 6;
const LONG DISP_DI_OUTPUT					= DISP_DI_OUTPUT_NORMAL;
const LONG DISP_DI_FLASH_BITMAP				= 7;
const LONG DISP_DI_LAYOUT					= 8;
const LONG DISP_DI_ROW_COLUMN				= 9;
const LONG DISP_DI_DISPLAY_BACKGROUND_COLOR	= 10;
const LONG DISP_DI_SLIDESHOW				= 11;
const LONG DISP_DI_SET_TEXT_COLOR			= 12;
const LONG DISP_DI_SET_BARCODE_DATA			= 13;
const LONG DISP_DI_DISPLAY_BARCODE			= 14;
const LONG DISP_DI_CLEAR_BARCODE			= 15;
const LONG DISP_DI_REGISTER_IMAGE			= 16;
const LONG DISP_DI_DISPLAY_IMAGE			= 17;
const LONG DISP_DI_DISPLAY_NV_IMAGE			= 18;
const LONG DISP_DI_CLEAR_IMAGE				= 19;
const LONG DISP_DI_SET_FONT					= 20;
const LONG DISP_DI_GET_FONT					= 21;


/////////////////////////////////////////////////
// pData
const LONG DISP_DI_DUMMY			= 0;
const LONG DISP_DI_MODE_CHARACTER	= 1;
const LONG DISP_DI_MODE_GRAPHICS	= 2;
const LONG DISP_DI_FONT_A			= 10;
const LONG DISP_DI_FONT_B			= 11;
const LONG DISP_DI_GW_NORMAL		= 20;
const LONG DISP_DI_GW_TRANSPARENT	= 21;

// [DISP_DI_SLIDESHOW]
const LONG DISP_DI_SLIDESHOW_START	= 30;
const LONG DISP_DI_SLIDESHOW_STOP	= 31;

// [DISP_DI_DISPLAY_BACKGROUND_COLOR], [DISP_DI_SET_TEXT_COLOR]
const LONG DISP_DI_BLACK				= 0x000000;
const LONG DISP_DI_NAVY					= 0x000080;
const LONG DISP_DI_DARKBLUE				= 0x00008B;
const LONG DISP_DI_MEDIUMBLUE			= 0x0000CD;
const LONG DISP_DI_BLUE					= 0x0000FF;
const LONG DISP_DI_DARKGREEN			= 0x006400;
const LONG DISP_DI_GREEN				= 0x008000;
const LONG DISP_DI_TEAL					= 0x008080;
const LONG DISP_DI_DARKCYAN				= 0x008B8B;
const LONG DISP_DI_DEEPSKYBLUE			= 0x00BFFF;
const LONG DISP_DI_DARKTURQUOISE		= 0x00CED1;
const LONG DISP_DI_MEDIUMSPRINGGREEN	= 0x00FA9A;
const LONG DISP_DI_LIME					= 0x00FF00;
const LONG DISP_DI_SPRINGGREEN			= 0x00FF7F;
const LONG DISP_DI_AQUA					= 0x00FFFF;
const LONG DISP_DI_CYAN					= 0x00FFFF;
const LONG DISP_DI_MIDNIGHTBLUE			= 0x191970;
const LONG DISP_DI_DODGERBLUE			= 0x1E90FF;
const LONG DISP_DI_LIGHTSEAGREEN		= 0x20B2AA;
const LONG DISP_DI_FORESTGREEN			= 0x228B22;
const LONG DISP_DI_SEAGREEN				= 0x2E8B57;
const LONG DISP_DI_DARKSLATEGRAY		= 0x2F4F4F;
const LONG DISP_DI_DARKSLATEGREY		= 0x2F4F4F;
const LONG DISP_DI_LIMEGREEN			= 0x32CD32;
const LONG DISP_DI_MEDIUMSEAGREEN		= 0x3CB371;
const LONG DISP_DI_TURQUOISE			= 0x40E0D0;
const LONG DISP_DI_ROYALBLUE			= 0x4169E1;
const LONG DISP_DI_STEELBLUE			= 0x4682B4;
const LONG DISP_DI_DARKSLATEBLUE		= 0x483D8B;
const LONG DISP_DI_MEDIUMTURQUOISE		= 0x48D1CC;
const LONG DISP_DI_INDIGO				= 0x4B0082;
const LONG DISP_DI_DARKOLIVEGREEN		= 0x556B2F;
const LONG DISP_DI_CADETBLUE			= 0x5F9EA0;
const LONG DISP_DI_CORNFLOWERBLUE		= 0x6495ED;
const LONG DISP_DI_MEDIUMAQUAMARINE		= 0x66CDAA;
const LONG DISP_DI_DIMGRAY				= 0x696969;
const LONG DISP_DI_DIMGREY				= 0x696969;
const LONG DISP_DI_SLATEBLUE			= 0x6A5ACD;
const LONG DISP_DI_OLIVEDRAB			= 0x6B8E23;
const LONG DISP_DI_SLATEGRAY			= 0x708090;
const LONG DISP_DI_SLATEGREY			= 0x708090;
const LONG DISP_DI_LIGHTSLATEGRAY		= 0x778899;
const LONG DISP_DI_LIGHTSLATEGREY		= 0x778899;
const LONG DISP_DI_MEDIUMSLATEBLUE		= 0x7B68EE;
const LONG DISP_DI_LAWNGREEN			= 0x7CFC00;
const LONG DISP_DI_CHARTREUSE			= 0x7FFF00;
const LONG DISP_DI_AQUAMARINE			= 0x7FFFD4;
const LONG DISP_DI_MAROON				= 0x800000;
const LONG DISP_DI_PURPLE				= 0x800080;
const LONG DISP_DI_OLIVE				= 0x808000;
const LONG DISP_DI_GRAY					= 0x808080;
const LONG DISP_DI_GREY					= 0x808080;
const LONG DISP_DI_SKYBLUE				= 0x87CEEB;
const LONG DISP_DI_LIGHTSKYBLUE			= 0x87CEFA;
const LONG DISP_DI_BLUEVIOLET			= 0x8A2BE2;
const LONG DISP_DI_DARKRED				= 0x8B0000;
const LONG DISP_DI_DARKMAGENTA			= 0x8B008B;
const LONG DISP_DI_SADDLEBROWN			= 0x8B4513;
const LONG DISP_DI_DARKSEAGREEN			= 0x8FBC8F;
const LONG DISP_DI_LIGHTGREEN			= 0x90EE90;
const LONG DISP_DI_MEDIUMPURPLE			= 0x9370D8;
const LONG DISP_DI_DARKVIOLET			= 0x9400D3;
const LONG DISP_DI_PALEGREEN			= 0x98FB98;
const LONG DISP_DI_DARKORCHID			= 0x9932CC;
const LONG DISP_DI_YELLOWGREEN			= 0x9ACD32;
const LONG DISP_DI_SIENNA				= 0xA0522D;
const LONG DISP_DI_BROWN				= 0xA52A2A;
const LONG DISP_DI_DARKGRAY				= 0xA9A9A9;
const LONG DISP_DI_DARKGREY				= 0xA9A9A9;
const LONG DISP_DI_LIGHTBLUE			= 0xADD8E6;
const LONG DISP_DI_GREENYELLOW			= 0xADFF2F;
const LONG DISP_DI_PALETURQUOISE		= 0xAFEEEE;
const LONG DISP_DI_LIGHTSTEELBLUE		= 0xB0C4DE;
const LONG DISP_DI_POWDERBLUE			= 0xB0E0E6;
const LONG DISP_DI_FIREBRICK			= 0xB22222;
const LONG DISP_DI_DARKGOLDENROD		= 0xB8860B;
const LONG DISP_DI_MEDIUMORCHID			= 0xBA55D3;
const LONG DISP_DI_ROSYBROWN			= 0xBC8F8F;
const LONG DISP_DI_DARKKHAKI			= 0xBDB76B;
const LONG DISP_DI_SILVER				= 0xC0C0C0;
const LONG DISP_DI_MEDIUMVIOLETRED		= 0xC71585;
const LONG DISP_DI_INDIANRED			= 0xCD5C5C;
const LONG DISP_DI_PERU					= 0xCD853F;
const LONG DISP_DI_CHOCOLATE			= 0xD2691E;
const LONG DISP_DI_TAN					= 0xD2B48C;
const LONG DISP_DI_LIGHTGRAY			= 0xD3D3D3;
const LONG DISP_DI_LIGHTGREY			= 0xD3D3D3;
const LONG DISP_DI_PALEVIOLETRED		= 0xD87093;
const LONG DISP_DI_THISTLE				= 0xD8BFD8;
const LONG DISP_DI_ORCHID				= 0xDA70D6;
const LONG DISP_DI_GOLDENROD			= 0xDAA520;
const LONG DISP_DI_CRIMSON				= 0xDC143C;
const LONG DISP_DI_GAINSBORO			= 0xDCDCDC;
const LONG DISP_DI_PLUM					= 0xDDA0DD;
const LONG DISP_DI_BURLYWOOD			= 0xDEB887;
const LONG DISP_DI_LIGHTCYAN			= 0xE0FFFF;
const LONG DISP_DI_LAVENDER				= 0xE6E6FA;
const LONG DISP_DI_DARKSALMON			= 0xE9967A;
const LONG DISP_DI_VIOLET				= 0xEE82EE;
const LONG DISP_DI_PALEGOLDENROD		= 0xEEE8AA;
const LONG DISP_DI_LIGHTCORAL			= 0xF08080;
const LONG DISP_DI_KHAKI				= 0xF0E68C;
const LONG DISP_DI_ALICEBLUE			= 0xF0F8FF;
const LONG DISP_DI_HONEYDEW				= 0xF0FFF0;
const LONG DISP_DI_AZURE				= 0xF0FFFF;
const LONG DISP_DI_SANDYBROWN			= 0xF4A460;
const LONG DISP_DI_WHEAT				= 0xF5DEB3;
const LONG DISP_DI_BEIGE				= 0xF5F5DC;
const LONG DISP_DI_WHITESMOKE			= 0xF5F5F5;
const LONG DISP_DI_MINTCREAM			= 0xF5FFFA;
const LONG DISP_DI_GHOSTWHITE			= 0xF8F8FF;
const LONG DISP_DI_SALMON				= 0xFA8072;
const LONG DISP_DI_ANTIQUEWHITE			= 0xFAEBD7;
const LONG DISP_DI_LINEN				= 0xFAF0E6;
const LONG DISP_DI_LIGHTGOLDENRODYELLOW	= 0xFAFAD2;
const LONG DISP_DI_OLDLACE				= 0xFDF5E6;
const LONG DISP_DI_RED					= 0xFF0000;
const LONG DISP_DI_FUCHSIA				= 0xFF00FF;
const LONG DISP_DI_MAGENTA				= 0xFF00FF;
const LONG DISP_DI_DEEPPINK				= 0xFF1493;
const LONG DISP_DI_ORANGERED			= 0xFF4500;
const LONG DISP_DI_TOMATO				= 0xFF6347;
const LONG DISP_DI_HOTPINK				= 0xFF69B4;
const LONG DISP_DI_CORAL				= 0xFF7F50;
const LONG DISP_DI_DARKORANGE			= 0xFF8C00;
const LONG DISP_DI_LIGHTSALMON			= 0xFFA07A;
const LONG DISP_DI_ORANGE				= 0xFFA500;
const LONG DISP_DI_LIGHTPINK			= 0xFFB6C1;
const LONG DISP_DI_PINK					= 0xFFC0CB;
const LONG DISP_DI_GOLD					= 0xFFD700;
const LONG DISP_DI_PEACHPUFF			= 0xFFDAB9;
const LONG DISP_DI_NAVAJOWHITE			= 0xFFDEAD;
const LONG DISP_DI_MOCCASIN				= 0xFFE4B5;
const LONG DISP_DI_BISQUE				= 0xFFE4C4;
const LONG DISP_DI_MISTYROSE			= 0xFFE4E1;
const LONG DISP_DI_BLANCHEDALMOND		= 0xFFEBCD;
const LONG DISP_DI_PAPAYAWHIP			= 0xFFEFD5;
const LONG DISP_DI_LAVENDERBLUSH		= 0xFFF0F5;
const LONG DISP_DI_SEASHELL				= 0xFFF5EE;
const LONG DISP_DI_CORNSILK				= 0xFFF8DC;
const LONG DISP_DI_LEMONCHIFFON			= 0xFFFACD;
const LONG DISP_DI_FLORALWHITE			= 0xFFFAF0;
const LONG DISP_DI_SNOW					= 0xFFFAFA;
const LONG DISP_DI_YELLOW				= 0xFFFF00;
const LONG DISP_DI_LIGHTYELLOW			= 0xFFFFE0;
const LONG DISP_DI_IVORY				= 0xFFFFF0;
const LONG DISP_DI_WHITE				= 0xFFFFFF;

// [DISP_DI_SET_BARCODE_DATA], [DISP_DI_DISPLAY_BARCODE]
const LONG DISP_DI_QRCODE_MODEL_1	= 40;
const LONG DISP_DI_QRCODE_MODEL_2	= 41;

// [DISP_DI_SET_FONT], [DISP_DI_GET_FONT]
const LONG DISP_DI_FONT_ANK	= 0;
const LONG DISP_DI_FONT_JP	= 11;
const LONG DISP_DI_FONT_SC	= 21;
const LONG DISP_DI_FONT_TC	= 31;
const LONG DISP_DI_FONT_KO	= 41;

#endif                  // !defined(EPSNDISP_H)

