Option Strict Off
Option Explicit On
Friend Class Step7
	Inherits System.Windows.Forms.Form
	'Step 7 Changing reading mode.
	
	Private m_cscnPath As String 'path .bmp or .tif or .jpg
	Private m_blnMicrEvent As Boolean
	Private m_strMicrData As String
	Private m_lStoreIndex As Integer
	Private m_lImgFormat As Integer
	Private m_bMicrError As Boolean
	Private m_strChangeMode(1) As String
	Private m_strCurrentMode As String
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		'Close Aplication
		Me.Close()
	End Sub
	
	Private Sub cmdRetrieveSt_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdRetrieveSt.Click
		
		Dim strParam As String
		Dim lLen As Integer
		Dim strErrMsg As String
		Dim strXMLPath As String
		Dim strFindXMLPath As String
		
		strParam = txtRetrieveSt.Text
		strErrMsg = ""
		strFindXMLPath = ""
		
		' Obtains the statistics of the device and stores it in a file.
		With OPOSCheckScanner1
			.RetrieveStatistics(strParam)
			If (.ResultCode <> OPOS_SUCCESS) Then
				strErrMsg = "RetrieveStatistics method error." & vbCrLf & vbCrLf & strErrMsg
				strErrMsg = strErrMsg & "ResultCode = " & CStr(.ResultCode) & vbCrLf
				strErrMsg = strErrMsg & "ResultCodeExtended = " & CStr(.ResultCodeExtended)
				MsgBox(strErrMsg, MsgBoxStyle.OKOnly + MsgBoxStyle.Exclamation, "CheckScanner")
				Exit Sub
			End If
		End With
		
		strXMLPath = My.Application.Info.DirectoryPath & "\Sample.xml"
		'Delete XML file.
		strFindXMLPath = Dir(strXMLPath)
		If strFindXMLPath <> "" Then
			Kill((strXMLPath))
		End If
		'Create XML file.
		FileOpen(1, strXMLPath, OpenMode.Binary, OpenAccess.Write)
		FilePut(1, strParam)
		FileClose(1)
		
		' Opens another window and indicates the information of the XML file.
		Step7Browser.Show()
		
	End Sub
	
	Private Sub Combo2_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Combo2.SelectedIndexChanged
		Dim strChangeData As String
		Dim bAtMicr As Boolean
		Dim lDum As Integer
		Dim strDum As String
		
		strChangeData = VB6.GetItemString(Combo2, Combo2.SelectedIndex)
		
		If (m_strCurrentMode = strChangeData) Then
			Exit Sub
		End If
		
		With OPOSCheckScanner1
			Select Case strChangeData
				Case m_strChangeMode(0)
					lDum = CHK_DI_MODE_CHECKSCANNER
					If (m_bMicrError = False) Then
						bAtMicr = True
					Else
						bAtMicr = False
					End If
				Case m_strChangeMode(1)
					lDum = CHK_DI_MODE_CARDSCANNER
					bAtMicr = False
				Case Else
					Exit Sub
			End Select
			
			.DirectIO(CHK_DI_CHANGE_MODE, lDum, strDum)
			
			If (.ResultCode <> OPOS_SUCCESS) Then
				Combo2.Text = m_strCurrentMode
				Exit Sub
			Else
				Command4.Enabled = bAtMicr
				m_strCurrentMode = strChangeData
			End If
			
			.ImageFormat = m_lImgFormat
			
			Select Case .ImageFormat
				Case CHK_IF_TIFF
					m_cscnPath = "\Step7.tif" 'case .tif
				Case CHK_IF_BMP
					m_cscnPath = "\Step7.bmp" 'case .bmp
				Case CHK_IF_JPEG
					m_cscnPath = "\Step7.jpg" 'case .jpg
				Case Else
					m_cscnPath = "\Step7.bmp" 'case .bmp
			End Select
			
		End With
		
	End Sub
	
	Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
		
		'Clear displayed "DataSize"
		Label1.Text = ""
		System.Windows.Forms.Application.DoEvents()
		
		With OPOSCheckScanner1
			'EventClear
			.ClearInput()
			
			'Ready to fired event
			.DataEventEnabled = True
			
			'When Contrast property is used.
			'        .Color = CHK_CL_GRAYSCALE
			'        .Contrast = 0 'lightest image (0-49)
			''        .Contrast = 50 'default
			''        .Contrast = 90 'darkest image (51-100)
			
			'Add timeout function.
			While .BeginInsertion(3000) = OPOS_E_TIMEOUT
				If (MsgBox("Please insert a check.", MsgBoxStyle.OKCancel + MsgBoxStyle.Question) = MsgBoxResult.Cancel) Then
					.EndInsertion()
					Exit Sub
				End If
				System.Windows.Forms.Application.DoEvents()
			End While
			
			'Set paper & Scanning
			.EndInsertion()
			
			'Call to retrieve an image to the ImageData proparty
			.RetrieveImage(CHK_CROP_AREA_ENTIRE_IMAGE)
			
			If .ResultCode = OPOS_SUCCESS Then
				
				'Enable "CroppingArea" Group
				Frame1.Enabled = True
				
				'Enable "Renge" Option
				Option1(0).Enabled = True
				Option1(1).Enabled = True
				Option1(2).Enabled = True
				Option1(0).Checked = True
				
			End If
			
		End With
		
	End Sub
	
	Private Sub Command2_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command2.Click
		
		With OPOSCheckScanner1
			
			'Set FileID
			.FileID = "Epson CheckScanner SampleProgram Step7"
			
			'Set FileID
			.ImageTagData = "Epson CheckScanner SampleProgram Step7 ImageTagData"
			
			'Clear Image Data File
			.ClearImage(CHK_CLR_BY_FILEID)
			
			'StoreImage
			.StoreImage(m_lStoreIndex)
			
			'Displayed "rest number"
			Label3.Text = CStr(.RemainingImagesEstimate)
			
		End With
		
		MsgBox("A data was stored.")
		
	End Sub
	
	Private Sub Command3_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command3.Click
		
		Dim lDataSize As Integer
		
		'Get file size
		lDataSize = GetDataSize
		
		'Dispay ImageDataSize
		Label1.Text = CStr(lDataSize) & " byte"
		
		Call CreateFile(lDataSize)
		
		'Disable "CreateFile" button
		Command3.Enabled = False
		
		'finish message
		MsgBox("A file was created")
		
	End Sub
	
	Private Sub Command4_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command4.Click
		
		Dim strReadRange As String 'DirectIO read range
		Dim lReadData As Integer 'DirectIO data "ECHK_DI_EXTEND_PRESCAN"Or"ECHK_DI_EXTEND_READAREA" Or "ECHK_DI_EXTEND_ATTACHED"
		Dim strDum As String 'DirectIO dummy data
		Dim lDum As Integer 'DirectIO dummy data
		
		'Clear displayed "DataSize"
		Label1.Text = ""
		System.Windows.Forms.Application.DoEvents()
		
		With OPOSMICR1
			'Ready to fired event
			.DataEventEnabled = True
			
			If m_blnMicrEvent Then
				Exit Sub
			End If
			
			m_strMicrData = "DefaultData"
			
			While .BeginInsertion(3000) = OPOS_E_TIMEOUT
				If (MsgBox("Please insert a check.", MsgBoxStyle.OKCancel + MsgBoxStyle.Question) = MsgBoxResult.Cancel) Then
					.EndInsertion()
					Exit Sub
				End If
				System.Windows.Forms.Application.DoEvents()
			End While
			'Set paper
			.EndInsertion()
			
		End With
		
		Do Until m_blnMicrEvent
			System.Windows.Forms.Application.DoEvents()
		Loop 
		
		'///////////////CheckScanner Section
		
		With OPOSCheckScanner1
			.DocumentHeight = 2756
			.DocumentWidth = 5984
			
			
			strReadRange = "197,0,5984,2756"
			lReadData = ECHK_DI_EXTEND_READAREA + ECHK_DI_EXTEND_ATTACHED + ECHK_DI_EXTEND_PRESCAN
			
			.DirectIO(ECHK_DI_READ_AREA, lDum, strReadRange)
			.DirectIO(ECHK_DI_ATTACHED_DATA, lDum, m_strMicrData)
			
			.DirectIO(ECHK_DI_ENDINSERTION_EXTEND, lReadData, strDum)
			
			'Ready to fired event
			.DataEventEnabled = True
			
			'Read TIFF file
			.ImageFormat = CHK_IF_TIFF
			
			'Set paper & Scanning
			.BeginInsertion(3000)
			.EndInsertion()
			
			'Call to retrieve an image to the ImageData proparty
			.RetrieveImage(CHK_CROP_AREA_ENTIRE_IMAGE)
			
			If .ResultCode = OPOS_SUCCESS Then
				'Enable "CroppingArea" Group
				Frame1.Enabled = True
				
				'Enable "Renge" Option
				Option1(0).Enabled = True
				Option1(1).Enabled = True
				Option1(2).Enabled = True
				Option1(0).Checked = True
			End If
			
			'Clear DirectIO setting area
			lReadData = ECHK_DI_EXTEND_DEFAULT
			.DirectIO(ECHK_DI_ENDINSERTION_EXTEND, lReadData, strDum)
			
		End With
		m_blnMicrEvent = False
		
	End Sub
	
	Private Sub Command5_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command5.Click
		
		Dim lCnt As Integer 'Loop count
		Dim strStep As String '"Step2" or "Step3" or "Step4" or "Step5" or "Step6" or "Step7"
		
		With Combo1
			strStep = VB6.GetItemString(Combo1, .SelectedIndex)
			strStep = "Epson CheckScanner SampleProgram " & strStep
		End With
		
		With OPOSCheckScanner1
			
			'Ready to fired event
			.DataEventEnabled = True
			
			.FileID = strStep
			
			'Speciffic "FileID"
			.RetrieveMemory(CHK_LOCATE_BY_FILEID)
			
			.ClearImage(CHK_CLR_BY_FILEID)
			
			'Displayed "rest number"
			Label3.Text = CStr(.RemainingImagesEstimate)
			System.Windows.Forms.Application.DoEvents()
			
			If .ResultCode <> OPOS_SUCCESS Then
				'Error MessageBox
				MsgBox("NoData!")
			Else
				'Disable "CroppingArea" Group
				Frame1.Enabled = False
				
				'Disable "Renge" Option
				Option1(0).Enabled = False
				Option1(1).Enabled = False
				Option1(2).Enabled = False
			End If
			
		End With
		
	End Sub
	
	Private Sub Option1_CheckedChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Option1.CheckedChanged
		If eventSender.Checked Then
			Dim Index As Short = Option1.GetIndex(eventSender)
			
			Dim lCropAreaIndex As Integer
			
			lCropAreaIndex = Index + 1
			
			With OPOSCheckScanner1
				'Ready to fired event
				.DataEventEnabled = True
				
				Select Case Index
					Case 0
						.DefineCropArea(lCropAreaIndex, 0, 0, CHK_CROP_AREA_RIGHT, CHK_CROP_AREA_BOTTOM)
					Case 1
						.DefineCropArea(lCropAreaIndex, 3500, 2244, 2000, 456)
					Case 2
						.DefineCropArea(lCropAreaIndex, 5100, 236, 490, 214)
				End Select
				
				.RetrieveImage(lCropAreaIndex)
				m_lStoreIndex = lCropAreaIndex
			End With
			
		End If
	End Sub
	
	Private Sub Step7_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		Dim OBJ As Object
		Dim lSupportList(2) As Integer
		Dim lCount As Integer
		Dim lSupportMode As Integer
		Dim strSupportMode As String
		Dim strDum As String
		
		m_blnMicrEvent = False
		
		'Set "DefaultData"
		m_strMicrData = "DefaultData"
		
		m_lStoreIndex = 1
		
		With Combo1
			.Items.Add("Step2")
			.Items.Add("Step3")
			.Items.Add("Step4")
			.Items.Add("Step5")
			.Items.Add("Step6")
			.Items.Add("Step7")
			.SelectedIndex = 0 'Step2
		End With
		
		lSupportList(0) = CHK_DI_CHECKSCANNER
		lSupportList(1) = CHK_DI_CARDSCANNER
		lSupportList(2) = CHK_DI_TMSTORAGE
		
		m_strChangeMode(0) = "CheckScanner"
		m_strChangeMode(1) = "CardScanner"
		
		With OPOSCheckScanner1
			
			'Open the device
			'Use a Logical Device Name which has been set on the SetupPOS.
			.Open("Unit1")
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("This device has not been registered, or cannot use.")
				GoTo LoadError
			End If
			
			'Get the exclusive control right for the opened device.
			'Then the device is disable from other application.
			'(Notice:When using an old CO, use the Claim.)
			.ClaimDevice(1000)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to get the exclusive right for the device.")
				GoTo LoadError
			End If
			
			'Power reporting
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			'Enable the device.
			.DeviceEnabled = True
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Now the device is disable to use.")
				GoTo LoadError
			End If
			
			'Read TIFF file
			.ImageFormat = CHK_IF_TIFF
			
			'Read BMP file format
			'.ImageFormat = CHK_IF_BMP
			
			'Read JPEG file format
			'.ImageFormat = CHK_IF_JPEG
			
			m_lImgFormat = .ImageFormat
			
			Select Case .ImageFormat
				Case CHK_IF_TIFF
					m_cscnPath = "\Step7.tif" 'case .tif
				Case CHK_IF_BMP
					m_cscnPath = "\Step7.bmp" 'case .bmp
				Case CHK_IF_JPEG
					m_cscnPath = "\Step7.jpg" 'case .jpg
				Case Else
					m_cscnPath = "\Step7.bmp" 'case .bmp
			End Select
			
			.DirectIO(CHK_DI_GET_SUPPORT_FUNCTION, lSupportMode, strDum)
			For lCount = 2 To 0 Step -1
				If (lSupportList(lCount) <= lSupportMode) Then
					lSupportMode = lSupportMode - lSupportList(lCount)
					Select Case lCount
						Case 0
							Combo2.Items.Insert(0, m_strChangeMode(lCount))
							Command4.Enabled = True
						Case 1
							Combo2.Items.Insert(0, m_strChangeMode(lCount))
							Command4.Enabled = False
					End Select
				End If
			Next 
			
			m_strCurrentMode = VB6.GetItemString(Combo2, 0)
			
			If (Combo2.Items.Count > 0) Then
				Combo2.SelectedIndex = 0
			Else
				Combo2.Enabled = False
			End If
			
			'        lSupportMode = CHK_DI_SHARPNESS_ON
			'        .DirectIO CHK_DI_SHARPNESS_IMAGE, lSupportMode, strDum
			
			'Set the edit box of parameter input.Set the edit box of parameter input.
			txtRetrieveSt.Text = "ModelName,HoursPoweredCount"
			
			' Checks whether it has function to obtain
			' the statistics of devices.
			' If it does not have the function, invalidates
			' the [Retrieve Statistics] button and the edit box
			' of parameter input.
			If .CapStatisticsReporting = False Then
				cmdRetrieveSt.Enabled = False
				txtRetrieveSt.Enabled = False
				Frame5.Enabled = False
			End If
			
		End With
		
		With OPOSMICR1
			m_bMicrError = False
			'Open the device
			'Use a Logical Device Name which has been set on the SetupPOS.
			.Open("Unit1")
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("This device has not been registered, or cannot use.")
				m_bMicrError = True
				GoTo LoadMICRError
			End If
			
			'Get the exclusive control right for the opened device.
			'Then the device is disable from other application.
			'(Notice:When using an old CO, use the Claim.)
			.ClaimDevice(1000)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to get the exclusive right for the device.")
				m_bMicrError = True
				GoTo LoadMICRError
			End If
			
			'Power reporting
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			'Enable the device.
			.DeviceEnabled = True
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Now the device is disable to use.")
				m_bMicrError = True
				GoTo LoadMICRError
			End If
			
		End With
		
LoadMICRError: 
		If (m_bMicrError) Then
			Command4.Enabled = False
		End If
		
		'Disable "CroppingArea" Group
		Frame1.Enabled = False
		
		'Disable "Renge" Option
		Option1(0).Enabled = False
		Option1(1).Enabled = False
		Option1(2).Enabled = False
		
		'Disable "Store" button
		Command2.Enabled = False
		
		'Disable "create" button
		Command3.Enabled = False
		
		Exit Sub
		
		'Go to
		'Disable Button
LoadError: 
		
		For	Each OBJ In Me.Controls
			If OBJ.Name <> "OPOSCheckScanner1" And OBJ.Name <> "OPOSMICR1" Then
				OBJ.Enabled = False
			End If
		Next OBJ
		
		'Enabled exit button
		cmdExit.Enabled = True 'Only the exit button is enabled.
		
	End Sub
	
	Private Sub Step7_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSCheckScanner1
			
			'remove paper
			.BeginRemoval(OPOS_FOREVER)
			.EndRemoval()
			
			'Cancel the device
			.DeviceEnabled = False
			
			'Release the device exclusive control right.
			'(Notice:When using an old CO, use the Release.)
			.ReleaseDevice()
			
			'Finish using the device.
			.Close()
			
		End With
		
		With OPOSMICR1
			
			'remove paper
			.BeginRemoval(OPOS_FOREVER)
			.EndRemoval()
			
			'Cancel the device
			.DeviceEnabled = False
			
			'Release the device exclusive control right.
			'(Notice:When using an old CO, use the Release.)
			.ReleaseDevice()
			
			'Finish using the device.
			.Close()
			
		End With
		
	End Sub
	
	Private Sub OPOSCheckScanner1_ErrorEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposCheckScanner_CCO._IOPOSCheckScannerEvents_ErrorEventEvent) Handles OPOSCheckScanner1.ErrorEvent
		
		'Error MessageBox
		MsgBox("CheckScanner Error!" & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended))
		
		'Begin removal
		If eventArgs.ResultCode = OPOS_E_ILLEGAL Then
			With OPOSCheckScanner1
				.BeginRemoval(OPOS_FOREVER)
				.EndRemoval()
			End With
		End If
		
	End Sub
	
	Private Sub OPOSCheckScanner1_DataEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposCheckScanner_CCO._IOPOSCheckScannerEvents_DataEventEvent) Handles OPOSCheckScanner1.DataEvent
		
		'Ready to fired event
		OPOSCheckScanner1.DataEventEnabled = True
		
		'Dispay ImageDataSize
		Label1.Text = CStr(GetDataSize) & " byte"
		
		'Enable "Store" button
		Command2.Enabled = True
		
		'Enable "CreateFile" button
		Command3.Enabled = True
		
	End Sub
	
	Private Sub OPOSMICR1_DataEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposMICR_CCO._IOPOSMICREvents_DataEventEvent) Handles OPOSMICR1.DataEvent
		
		'End Doevents
		m_blnMicrEvent = True
		
		'Set "MICR RawData"
		m_strMicrData = OPOSMICR1.RawData
		
	End Sub
	
	Private Sub OPOSMICR1_ErrorEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposMICR_CCO._IOPOSMICREvents_ErrorEventEvent) Handles OPOSMICR1.ErrorEvent
		
		'Error MessageBox
		MsgBox("MICR Error!" & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended))
		
		'Begin removal
		If eventArgs.ResultCode = OPOS_E_ILLEGAL Then
			
			With OPOSMICR1
				.BeginRemoval(OPOS_FOREVER)
				.EndRemoval()
			End With
			
		End If
		
		'End Doevents
		m_blnMicrEvent = True
		
		'Set "ErrorData"
		m_strMicrData = "ErrorData"
		
	End Sub
	
	Private Function GetDataSize() As Integer
		
		Dim strIMSizeData As String
		Dim lImageDataSize As Integer
		Dim lNowBinaryConversion As Integer
		
		With OPOSCheckScanner1
			
			'Now BinaryConversion
			lNowBinaryConversion = .BinaryConversion
			
			'Set BinaryConversion
			.BinaryConversion = OPOS_BC_NIBBLE
			
			'Copy to ImageData
			strIMSizeData = .ImageData
			
			'GetDataSize
			lImageDataSize = Len(strIMSizeData) / 2
			
			'Re BinaryConversion
			.BinaryConversion = lNowBinaryConversion
			
		End With
		
		'Return ImageDataSize
		GetDataSize = lImageDataSize
		
	End Function
	
	Private Sub CreateFile(ByRef lImDataSize As Integer)
		
		Dim rtBNext As Integer 'See part of 2byte
		Dim rtBLen As Integer 'Byte Array Count
		Dim strHigh As String 'byte High
		Dim strLow As String 'byte Low
		Dim strIMData As String 'Main Data
		Dim bytTrans() As Byte 'dynamic array declaration statement
		Dim lNowBinaryConversion As Integer 'Now BinaryConversion
		
		rtBNext = 1 'start position
		
		With OPOSCheckScanner1
			
			'Now BinaryConversion
			lNowBinaryConversion = .BinaryConversion
			
			'SetBinaryConversion
			.BinaryConversion = OPOS_BC_NIBBLE
			
			'Copy to ImageData
			strIMData = .ImageData
			
			ReDim bytTrans(lImDataSize - 1) '2byte--->1byte
			
			For rtBLen = 0 To lImDataSize - 1
				strHigh = Mid(strIMData, rtBNext, 1) 'first string
				strLow = Mid(strIMData, rtBNext + 1, 1) 'second string
				rtBNext = rtBNext + 2
				bytTrans(rtBLen) = CByte(ChangeAsc(strHigh) * 16 + ChangeAsc(strLow))
				System.Windows.Forms.Application.DoEvents()
			Next rtBLen
			
			'Save file for binary mode
			FileOpen(1, My.Application.Info.DirectoryPath & m_cscnPath, OpenMode.Binary)
			FilePut(1, bytTrans)
			FileClose(1)
			
			'Re BinaryConversion
			.BinaryConversion = lNowBinaryConversion
			
		End With
		
	End Sub
	
	'change specialized epson string
	Private Function ChangeAsc(ByRef strCmd As String) As Byte
		
		Select Case strCmd
			Case ":"
				ChangeAsc = 10
			Case ";"
				ChangeAsc = 11
			Case "<"
				ChangeAsc = 12
			Case "="
				ChangeAsc = 13
			Case ">"
				ChangeAsc = 14
			Case "?"
				ChangeAsc = 15
			Case Else
				ChangeAsc = CByte(strCmd)
		End Select
		
	End Function
End Class