Option Strict Off
Option Explicit On
Imports VB = Microsoft.VisualBasic
Friend Class Step11
	Inherits System.Windows.Forms.Form
	'Step 11 Display bitmaps.
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	Private Sub cmdRetrieveSt_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdRetrieveSt.Click
		
		Dim strParam As String
		Dim lLen As Integer
		Dim strErrMsg As String
		Dim strXMLPath As String
		Dim strFindXMLPath As String
		
		strParam = txtRetrieveSt.Text
		strErrMsg = ""
		strFindXMLPath = ""
		
		' Obtains the statistics of the device and stores it in a file.
		With OPOSLineDisplay1
			.RetrieveStatistics(strParam)
			If (.ResultCode <> OPOS_SUCCESS) Then
				strErrMsg = "RetrieveStatistics method error." & vbCrLf & vbCrLf
				strErrMsg = strErrMsg & "ResultCode = " & CStr(.ResultCode) & vbCrLf
				strErrMsg = strErrMsg & "ResultCodeExtended = " & CStr(.ResultCodeExtended)
				MsgBox(strErrMsg, MsgBoxStyle.OKOnly + MsgBoxStyle.Exclamation, "Display")
				Exit Sub
			End If
		End With
		
		strXMLPath = My.Application.Info.DirectoryPath & "\Sample.xml"
		'Delete XML file.
		strFindXMLPath = Dir(strXMLPath)
		If strFindXMLPath <> "" Then
			Kill((strXMLPath))
		End If
		'Create XML file.
		FileOpen(1, strXMLPath, OpenMode.Binary, OpenAccess.Write)
		FilePut(1, strParam)
		FileClose(1)
		
		' Opens another window and indicates the information of the XML file.
		Step11Browser.Show()
		
	End Sub
	
	'Clear the text on the window
	'
	Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
		
		OPOSLineDisplay1.ClearText()
		
	End Sub
	
	'Display the text as specified.
	'
	Private Sub Command2_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command2.Click
		
		OPOSLineDisplay1.DisplayTextAt(1, 5, "Hello OPOS.", DISP_DT_NORMAL)
		
	End Sub
	
	
	'Display the blinking text
	'
	Private Sub Command3_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command3.Click
		
		OPOSLineDisplay1.DisplayText("Blink", DISP_DT_BLINK)
		
	End Sub
	
	'Teletype display
	'
	Private Sub Command4_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command4.Click
		
		OPOSLineDisplay1.InterCharacterWait = 1000
		OPOSLineDisplay1.DisplayText("Teletype", DISP_DT_NORMAL)
		
	End Sub
	
	Private Sub Command4_Leave(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command4.Leave
		
		OPOSLineDisplay1.InterCharacterWait = 0
		
	End Sub
	
	'Scrolled display
	'
	Private Sub Command5_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command5.Click
		Dim Index As Short = Command5.GetIndex(eventSender)
		
		If Index = 0 Then
			' Move one character to the left side
			OPOSLineDisplay1.ScrollText(DISP_ST_LEFT, 1)
		Else
			' Move two characters to the right side
			OPOSLineDisplay1.ScrollText(DISP_ST_RIGHT, 2)
		End If
		
	End Sub
	
	
	'Window control
	'
	Private Sub Command6_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command6.Click
		
		With OPOSLineDisplay1
			.CreateWindow(1, 10, 1, 10, 1, 34)
			.MarqueeFormat = DISP_MF_WALK
			.MarqueeType = DISP_MT_INIT
			.MarqueeRepeatWait = 1000
			.MarqueeUnitWait = 100
			.DisplayText("Sale! 50%-20% OFF!", DISP_DT_NORMAL)
			.MarqueeType = DISP_MT_LEFT
			
			MsgBox("When pressing OK, it ends")
			
			.MarqueeType = DISP_MT_INIT
			.DestroyWindow()
		End With
		
	End Sub
	
	'Display various characters
	'
	Private Sub Command7_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command7.Click
		
		Dim ESC As New VB6.FixedLengthString(1)
		
		ESC.Value = Chr(&H1Bs)
		With OPOSLineDisplay1
			.ClearText()
			.DisplayTextAt(0, 0, "Normal " & ESC.Value & "|bCBold", DISP_DT_NORMAL)
			.DisplayTextAt(1, 0, ESC.Value & "|rvCReverse" & ESC.Value & "|bCBold&Reverse", DISP_DT_NORMAL)
			.DisplayText(Chr(&H1Bs) & "|bC Bold", DISP_DT_NORMAL)
		End With
		
	End Sub
	
	'Display a bitmap
	'
	Private Sub Command8_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command8.Click
		
		Dim ESC As New VB6.FixedLengthString(1)
		Dim pData As Integer
		Dim pString As String
		
		ESC.Value = Chr(&H1Bs)
		With OPOSLineDisplay1
			pData = 1
			pString = My.Application.Info.DirectoryPath & "\Logo.bmp"
			.DirectIO(DISP_DI_SETIMAGE, pData, pString)
			pData = DISP_DI_DUMMY
			pString = ""
			.DirectIO(DISP_DI_GRAPHIC, pData, pString)
			.CreateWindow(0, 0, 64, 256, 64, 256)
			.DisplayText(ESC.Value & "|1B", DISP_DT_NORMAL)
			
			MsgBox("When pressing Ok button, delete the window.")
			
			.DestroyWindow()
		End With
		
	End Sub
	
	Private Sub Step11_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSLineDisplay1
			.Open("Unit1")
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("This device has not been registered, or cannot use.")
				GoTo LoadError
			End If
			
			.ClaimDevice(1000)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to get the exclusive right for the device.")
				GoTo LoadError
			End If
			
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			.DeviceEnabled = True
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Now the device is disable to use.")
				GoTo LoadError
			End If
			
			'Supports only for the Graphic Display(EPSON DM-D500 series)
			If VB.Left(.DeviceName, 5) <> "DM-D5" Then
				Frame2.Enabled = False 'Frame
				Command7.Enabled = False 'Various characters
				Command8.Enabled = False 'Disable the bitmap
			End If
			
			' Set the edit box of parameter input.
			txtRetrieveSt.Text = "ModelName,HoursPoweredCount,OnlineTransitionCount"
			
			' Checks whether it has function to obtain
			' the statistics of devices.
			' If it does not have the function, invalidates
			' the [Retrieve Statistics] button and the edit box
			' of parameter input.
			If .CapStatisticsReporting = False Then
				cmdRetrieveSt.Enabled = False
				txtRetrieveSt.Enabled = False
			End If
			
		End With
		
		Exit Sub
		
LoadError: 
		Dim OBJ As Object
		For	Each OBJ In Me.Controls
			If OBJ.Name <> "OPOSLineDisplay1" Then
				OBJ.Enabled = False
			End If
		Next OBJ
		cmdExit.Enabled = True 'Only the exit button is enabled.
		
	End Sub
	
	Private Sub Step11_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSLineDisplay1
			.ClearText()
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
	
	Private Sub OPOSLineDisplay1_StatusUpdateEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposLineDisplay_CCO._IOPOSLineDisplayEvents_StatusUpdateEventEvent) Handles OPOSLineDisplay1.StatusUpdateEvent
		
		'The Power Reporting Requirements fires the event when the device power status is changed.
		Select Case eventArgs.Data
			Case OPOS_SUE_POWER_ONLINE ' The device is powered on.
				MsgBox("The device is powered on.")
			Case OPOS_SUE_POWER_OFF ' The device is powered off, or unconnected.
				MsgBox("The device is powered off, or unconnected.")
			Case OPOS_SUE_POWER_OFFLINE ' The device is powered on, but disable to operate.
				MsgBox("The device is powered on, but disable to operate..")
			Case OPOS_SUE_POWER_OFF_OFFLINE ' The device is powered off or off-line.
				MsgBox("The device is powered off or off-line.")
		End Select
		
	End Sub
End Class