Option Strict Off
Option Explicit On
Friend Class Form3
	Inherits System.Windows.Forms.Form
	
	' Struct for FileDialog
	Private Structure OpenFileName
		Dim lStructSize As Integer
		Dim hwndOwner As Integer
		Dim hInstance As Integer
		Dim lpstrFilter As String
		Dim lpstrCustomFilter As String
		Dim nMaxCustFilter As Integer
		Dim nFilterIndex As Integer
		Dim lpstrFile As String
		Dim nMaxFile As Integer
		Dim lpstrFileTitle As String
		Dim nMaxFileTitle As Integer
		Dim lpstrInitialDir As String
		Dim lpstrTitle As String
		Dim flags As Integer
		Dim nFileOffset As Short
		Dim nFileExtension As Short
		Dim lpstrDefExt As String
		Dim lCustData As Integer
		Dim lpfnHook As Integer
		Dim lpTemplateName As String
	End Structure
	
	' File dialog Function
	Private Declare Function GetOpenFileName Lib "comdlg32.dll"  Alias "GetOpenFileNameA"(ByRef pOpenfilename As OpenFileName) As Integer
	
	
	Private Sub AddMarkerButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles AddMarkerButton.Click
		
		With OPOSElectronicJournal1
			' Add marker to storage
			.AddMarker(MarkerEdit.Text)
			
			' Notify AddMarker method error
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Add Marker." & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
		End With
		
	End Sub
	
	
	Private Sub AsyncModeCheck_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles AsyncModeCheck.CheckStateChanged
		
		' Change print and query process with Asynchronous or Sysnchronous.
		Dim CheckBoxValue As Short
		With OPOSElectronicJournal1
			.AsyncMode = AsyncModeCheck.CheckState
			
			
			If .AsyncMode Then
				CheckBoxValue = 1
			Else
				CheckBoxValue = 0
			End If
			
			AsyncModeCheck.CheckState = CheckBoxValue
			
		End With
		
	End Sub
	
	Private Sub DataEventEnabledCheck_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles DataEventEnabledCheck.CheckStateChanged
		
		' Handling DataEvent for Asynchronous QueryContent Method.
		Dim CheckBoxValue As Short
		With OPOSElectronicJournal1
			.DataEventEnabled = DataEventEnabledCheck.CheckState
			
			
			If .DataEventEnabled Then
				CheckBoxValue = 1
			Else
				CheckBoxValue = 0
			End If
			
			DataEventEnabledCheck.CheckState = CheckBoxValue
			
		End With
		
	End Sub
	
	Private Sub ExitButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles ExitButton.Click
		
		Me.Close()
		
	End Sub
	
	Private Sub FileChooseButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles FileChooseButton.Click
		Dim lngHWnd As Object
		
		Dim typFileName As OpenFileName
		
		With typFileName
			.lStructSize = Len(typFileName)
			.hwndOwner = lngHWnd
			.hInstance = VB6.GetHInstance.ToInt32
			.lpstrFilter = "*.*"
			.nFilterIndex = 1
			.lpstrFile = New String(Chr(0), 256)
			.nMaxFile = 256
			.nMaxFileTitle = 256
			.lpstrFileTitle = New String(Chr(0), 256)
			.lpstrInitialDir = "."
			.lpstrTitle = "Open File"
			.flags = &H1000 'OFN_FILEMUSTEXIST
		End With
		
		If GetOpenFileName(typFileName) <> 0 Then
			PrintFileNameEdit.Text = typFileName.lpstrFile
		End If
		
	End Sub
	
	Private Sub Form3_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSPOSPrinter1
			.Open("Unit1")
			'Check whether the device is succeed to open, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to open the POSPrinter device.")
				GoTo LoadErrorPtr
			End If
			
			.ClaimDevice(1000)
			'Check whether the device is claim to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to claim the POSPrinter device.")
				GoTo LoadErrorPtr
			End If
			
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			.DeviceEnabled = True
			'Check whether the device is enable to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Disable to use the POSPrinter device.")
				GoTo LoadErrorPtr
			End If
			
		End With
		
		With OPOSElectronicJournal1
			
			.Open("Unit1")
			'Check whether the device is succeed to open, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to open the ElectronicJournal device.")
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
			.ClaimDevice(1000)
			'Check whether the device is claim to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to claim the ElectronicJournal device.")
				GoTo LoadErrorEJ
			End If
			
			.DeviceEnabled = True
			'Check whether the device is enable to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Disable to use the ElectronicJournal device.")
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
			.StorageEnabled = True
			'Check whether the device is store enabled to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to storage enabled.")
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
			If .StorageEnabled Then
				StorageEnabledCheck.CheckState = System.Windows.Forms.CheckState.Checked
			Else
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
		End With
		
		FileNameEdit.Text = My.Application.Info.DirectoryPath & "\" & FileNameEdit.Text
		PrintFileNameEdit.Text = My.Application.Info.DirectoryPath & "\" & PrintFileNameEdit.Text
		
		PrintButton.Enabled = True
		
		Exit Sub
		
LoadErrorPtr: 
		'Disable POSPrinter Control
		PrintButton.Enabled = False
		
		ExitButton.Enabled = True
		
LoadErrorEJ: 
		'Disable ElectronicJournal Control
		StorageEnabledCheck.Enabled = False
		DataEventEnabledCheck.Enabled = False
		AsyncModeCheck.Enabled = False
		AddMarkerButton.Enabled = False
		MarkerEdit.Enabled = False
		PrintContentFileButton.Enabled = False
		FileNameEdit.Enabled = False
		PrintFileNameEdit.Enabled = False
		StartMarkerEdit.Enabled = False
		EndMarkerEdit.Enabled = False
		FileChooseButton.Enabled = False
		QueryContentButton.Enabled = False
		
		ExitButton.Enabled = True
		
	End Sub
	
	Private Sub Form3_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSPOSPrinter1
			
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
			
		End With
		
		With OPOSElectronicJournal1
			
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
			
		End With
		
	End Sub
	
	
	
	Private Sub OPOSElectronicJournal1_DataEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposElectronicJournal_CCO._IOPOSElectronicJournalEvents_DataEventEvent) Handles OPOSElectronicJournal1.DataEvent
		
		MsgBox("Complete Querying Content: Status = " & CStr(eventArgs.Status))
		
		DataEventEnabledCheck.CheckState = OPOSElectronicJournal1.DataEventEnabled
		
	End Sub
	
	
	Private Sub OPOSElectronicJournal1_OutputCompleteEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposElectronicJournal_CCO._IOPOSElectronicJournalEvents_OutputCompleteEventEvent) Handles OPOSElectronicJournal1.OutputCompleteEvent
		
		MsgBox("Complete Printing Content File : ID = " & CStr(eventArgs.OutputID), MsgBoxStyle.OKOnly, "EJSample_Step3")
		
	End Sub
	
	Private Sub OPOSElectronicJournal1_ErrorEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposElectronicJournal_CCO._IOPOSElectronicJournalEvents_ErrorEventEvent) Handles OPOSElectronicJournal1.ErrorEvent
		
		' Handling error event to asynchronous print/query process.
		Dim DialogMessage As String
		Dim DialogResult_Renamed As Short
		
		If eventArgs.ErrorLocus = OPOS_EL_OUTPUT Then
			' Error from asynchronous print.
			DialogMessage = "Output Error" & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended)
			DialogResult_Renamed = MsgBox(DialogMessage, MsgBoxStyle.RetryCancel, "EJSample_Step3")
			
			If DialogResult_Renamed = MsgBoxResult.Retry Then
				' Retry asynchronous print
				eventArgs.pErrorResponse = OPOS_ER_RETRY
			ElseIf DialogResult_Renamed = MsgBoxResult.Cancel Then 
				' Clear asynchronous print
				eventArgs.pErrorResponse = OPOS_ER_CLEAR
			End If
			
		ElseIf eventArgs.ErrorLocus = OPOS_EL_INPUT_DATA Then 
			DialogMessage = "InputData Error" & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended)
			DialogResult_Renamed = MsgBox(DialogMessage, MsgBoxStyle.OKCancel, "EJSample_Step3")
			
			If DialogResult_Renamed = MsgBoxResult.OK Then
				' Continue to receive input events.
				eventArgs.pErrorResponse = OPOS_ER_CONTINUEINPUT
			ElseIf DialogResult_Renamed = MsgBoxResult.Cancel Then 
				' Clear all input events.
				eventArgs.pErrorResponse = OPOS_ER_CLEAR
			End If
			
		ElseIf eventArgs.ErrorLocus = OPOS_EL_INPUT Then 
			DialogMessage = "Input Error" & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended)
			DialogResult_Renamed = MsgBox(DialogMessage, MsgBoxResult.OK, "EJSample_Step3")
			
		End If
		
		
		
	End Sub
	
	Private Sub PrintButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles PrintButton.Click
		
		' Print receipt by POSPrinter.
		' For detail refer POSPrinter SampleProgram.
		Dim rcSpacing As Integer
		Dim rcHeight As Integer
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1B)
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm")
		
		With OPOSPOSPrinter1
			rcSpacing = .RecLineSpacing
			rcHeight = .RecLineHeight
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_LEFT90)
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & ESC.Value & "|bC" & "   Receipt     ")
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|3C" & ESC.Value & "|2uC" & "       Mr. Brawn" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & "                                                  " & vbCrLf & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & ESC.Value & "|3C" & "        Total payment              $" & ESC.Value & "|4C" & "21.00  " & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, fDate & " Received" & vbCrLf & vbCrLf)
			.RecLineHeight = 24
			.RecLineSpacing = .RecLineHeight
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Details               " & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & "                          " & ESC.Value & "|2C" & "OPOS Store" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Tax excluded    $20.00" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & "                          " & ESC.Value & "|bC" & "Zip code 999-9999" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Tax(5%)        $1.00" & ESC.Value & "|N" & "    Phone#(9999)99-9998" & vbCrLf)
			
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_NORMAL)
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|fP")
			
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
			
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Receipt print. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
			
			.RecLineSpacing = rcSpacing
			.RecLineHeight = rcHeight
		End With
		
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	
	
	Private Sub PrintContentFileButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles PrintContentFileButton.Click
		
		' Print ElectronicJournal file that extracted storage.
		With OPOSElectronicJournal1
			.PrintContentFile(PrintFileNameEdit.Text)
			
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Print ElectronicJournalFile. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
		End With
		
	End Sub
	
	Private Sub QueryContentButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles QueryContentButton.Click
		
		' Extract storage content by from marker to marker.
		With OPOSElectronicJournal1
			.QueryContent(FileNameEdit.Text, StartMarkerEdit.Text, EndMarkerEdit.Text)
			
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Create ElectronicJournalFile. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
		End With
		
	End Sub
	
	Private Sub StorageEnabledCheck_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles StorageEnabledCheck.CheckStateChanged
		
		' ElectronicJournal storage Start / Stop
		Dim CheckBoxValue As Short
		With OPOSElectronicJournal1
			.StorageEnabled = StorageEnabledCheck.CheckState
			
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Storage Ready. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
			
			
			If .StorageEnabled Then
				CheckBoxValue = 1
			Else
				CheckBoxValue = 0
			End If
			
			StorageEnabledCheck.CheckState = CheckBoxValue
			
		End With
	End Sub
End Class