Option Strict Off
Option Explicit On
Friend Class Form4
	Inherits System.Windows.Forms.Form
	
	' Struct for FileDialog
	Private Structure OpenFileName
		Dim lStructSize As Integer
		Dim hwndOwner As Integer
		Dim hInstance As Integer
		Dim lpstrFilter As String
		Dim lpstrCustomFilter As String
		Dim nMaxCustFilter As Integer
		Dim nFilterIndex As Integer
		Dim lpstrFile As String
		Dim nMaxFile As Integer
		Dim lpstrFileTitle As String
		Dim nMaxFileTitle As Integer
		Dim lpstrInitialDir As String
		Dim lpstrTitle As String
		Dim flags As Integer
		Dim nFileOffset As Short
		Dim nFileExtension As Short
		Dim lpstrDefExt As String
		Dim lCustData As Integer
		Dim lpfnHook As Integer
		Dim lpTemplateName As String
	End Structure
	
	' File dialog Function
	Private Declare Function GetOpenFileName Lib "comdlg32.dll"  Alias "GetOpenFileNameA"(ByRef pOpenfilename As OpenFileName) As Integer
	
	' ErrorEvet recovery type
	Public ErrorRecovery As Short
	
	' ElectonicJournal Asynchronous Printing
	Public EJAsyncPrinting As Boolean
	' NearEnd detection
	Public NearEndDetect As Boolean
	
	
	Private Sub AddMarkerButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles AddMarkerButton.Click
		
		With OPOSElectronicJournal1
			' Add marker to storage
			.AddMarker(MarkerEdit.Text)
			
			' Notify AddMarker method error.
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Add Marker." & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
		End With
		
	End Sub
	
	
	Private Sub AsyncModeCheck_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles AsyncModeCheck.CheckStateChanged
		
		' Change print and query process with Asynchronous or Sysnchronous.
		Dim CheckBoxValue As Short
		With OPOSElectronicJournal1
			.AsyncMode = AsyncModeCheck.CheckState
			
			
			If .AsyncMode Then
				CheckBoxValue = 1
			Else
				CheckBoxValue = 0
			End If
			
			AsyncModeCheck.CheckState = CheckBoxValue
			
		End With
		
	End Sub
	
	Private Sub CancelPrintContentButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles CancelPrintContentButton.Click
		
		' Cancel suspended print process.
		With OPOSElectronicJournal1
			.CancelPrintContent()
			
			If .ResultCode = OPOS_SUCCESS Then
				EJAsyncPrinting = False
				' SuspendMode end.
				CancelPrintContentButton.Enabled = False
				ResumePrintContentButton.Enabled = False
				
			Else
				
				MsgBox("Failed to Cancel Print. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
			
		End With
		
	End Sub
	
	Private Sub DataEventEnabledCheck_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles DataEventEnabledCheck.CheckStateChanged
		
		' Handling DataEvent for Asynchronous QueryContent Method.
		Dim CheckBoxValue As Short
		With OPOSElectronicJournal1
			.DataEventEnabled = DataEventEnabledCheck.CheckState
			
			
			If .DataEventEnabled Then
				CheckBoxValue = 1
			Else
				CheckBoxValue = 0
			End If
			
			DataEventEnabledCheck.CheckState = CheckBoxValue
			
		End With
		
	End Sub
	
	Private Sub ExitButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles ExitButton.Click
		
		Me.Close()
		
	End Sub
	
	
	
	Private Sub FileChooseButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles FileChooseButton.Click
		Dim lngHWnd As Object
		
		Dim typFileName As OpenFileName
		
		With typFileName
			.lStructSize = Len(typFileName)
			.hwndOwner = lngHWnd
			.hInstance = VB6.GetHInstance.ToInt32
			.lpstrFilter = "*.*"
			.nFilterIndex = 1
			.lpstrFile = New String(Chr(0), 256)
			.nMaxFile = 256
			.nMaxFileTitle = 256
			.lpstrFileTitle = New String(Chr(0), 256)
			.lpstrInitialDir = "."
			.lpstrTitle = "Open File"
			.flags = &H1000 'OFN_FILEMUSTEXIST
		End With
		
		If GetOpenFileName(typFileName) <> 0 Then
			PrintFileNameEdit.Text = typFileName.lpstrFile
		End If
		
		
	End Sub
	
	Private Sub Form4_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSPOSPrinter1
			.Open("Unit1")
			'Check whether the device is succeed to open, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to open the POSPrinter device.")
				GoTo LoadErrorPtr
			End If
			
			.ClaimDevice(1000)
			'Check whether the device is claim to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to claim the POSPrinter device.")
				GoTo LoadErrorPtr
			End If
			
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			.DeviceEnabled = True
			'Check whether the device is enable to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Disable to use the POSPrinter device.")
				GoTo LoadErrorPtr
			End If
			
		End With
		
		With OPOSElectronicJournal1
			
			.Open("Unit1")
			'Check whether the device is succeed to open, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to open the ElectronicJournal device.")
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
			.ClaimDevice(1000)
			'Check whether the device is claim to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to claim the ElectronicJournal device.")
				GoTo LoadErrorEJ
			End If
			
			.DeviceEnabled = True
			'Check whether the device is enable to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Disable to use the ElectronicJournal device.")
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
			.StorageEnabled = True
			'Check whether the device is store enabled to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to storage enabled.")
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
			If .StorageEnabled Then
				StorageEnabledCheck.CheckState = System.Windows.Forms.CheckState.Checked
			Else
				GoTo LoadErrorEJ
				Exit Sub
			End If
			
		End With
		
		FileNameEdit.Text = My.Application.Info.DirectoryPath & "\" & FileNameEdit.Text
		PrintFileNameEdit.Text = My.Application.Info.DirectoryPath & "\" & PrintFileNameEdit.Text
		
		EJAsyncPrinting = False
		NearEndDetect = False
		
		PrintButton.Enabled = True
		
		SuspendPrintContentButton.Enabled = False
		ResumePrintContentButton.Enabled = False
		CancelPrintContentButton.Enabled = False
		
		Exit Sub
		
LoadErrorPtr: 
		'Disable POSPrinter Control
		PrintButton.Enabled = False
		
		ExitButton.Enabled = True
		
LoadErrorEJ: 
		'Disable ElectronicJournal Control
		StorageEnabledCheck.Enabled = False
		DataEventEnabledCheck.Enabled = False
		AsyncModeCheck.Enabled = False
		AddMarkerButton.Enabled = False
		MarkerEdit.Enabled = False
		PrintContentFileButton.Enabled = False
		FileNameEdit.Enabled = False
		PrintFileNameEdit.Enabled = False
		StartMarkerEdit.Enabled = False
		EndMarkerEdit.Enabled = False
		FileChooseButton.Enabled = False
		QueryContentButton.Enabled = False
		SuspendPrintContentButton.Enabled = False
		ResumePrintContentButton.Enabled = False
		CancelPrintContentButton.Enabled = False
		
		ExitButton.Enabled = True
		
	End Sub
	
	Private Sub Form4_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSPOSPrinter1
			
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
			
		End With
		
		With OPOSElectronicJournal1
			
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
			
		End With
		
	End Sub
	
	Private Sub OPOSElectronicJournal1_DataEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposElectronicJournal_CCO._IOPOSElectronicJournalEvents_DataEventEvent) Handles OPOSElectronicJournal1.DataEvent
		
		MsgBox("Complete Querying Content: Status = " & CStr(eventArgs.Status))
		
		DataEventEnabledCheck.CheckState = OPOSElectronicJournal1.DataEventEnabled
		
	End Sub
	
	Private Sub OPOSElectronicJournal1_ErrorEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposElectronicJournal_CCO._IOPOSElectronicJournalEvents_ErrorEventEvent) Handles OPOSElectronicJournal1.ErrorEvent
		
		' Handling error event to asynchronous print/query process.
		Dim DialogMessage As String
		Dim DialogResult_Renamed As Short
		
		' Error from asynchronous print process.
		If eventArgs.ErrorLocus = OPOS_EL_OUTPUT Then
			DialogMessage = "Output Error" & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended)
			ErrorRecovery = 0
			
			ErrorEventDlg.ErrorMessageLabel.Text = DialogMessage
			
			ErrorEventDlg.ErrorSuspendButton.Text = "Suspend Process"
			ErrorEventDlg.ErrorRetryButton.Text = "Retry Process"
			ErrorEventDlg.ErrorCancelButton.Text = "Cancel Process"
			ErrorEventDlg.ErrorSuspendButton.Enabled = True
			ErrorEventDlg.ErrorRetryButton.Enabled = True
			ErrorEventDlg.ErrorCancelButton.Enabled = True
			
			VB6.ShowForm(ErrorEventDlg, 1, Me)
			
			If ErrorRecovery = 0 Then
				' Cancel asynchronous print
				eventArgs.pErrorResponse = OPOS_ER_CLEAR
				SuspendPrintContentButton.Enabled = False
				EJAsyncPrinting = False
				
			ElseIf ErrorRecovery = 1 Then 
				' Retry asynchronous print
				eventArgs.pErrorResponse = OPOS_ER_RETRY
				SuspendPrintContentButton.Enabled = True
				EJAsyncPrinting = True
				
			ElseIf ErrorRecovery = 2 Then 
				' Suspend asynchronous print
				OPOSElectronicJournal1.SuspendPrintContent()
				
				eventArgs.pErrorResponse = OPOS_ER_RETRY
				EJAsyncPrinting = False
				
			End If
			
			' Error from asynchronous query process.
		ElseIf eventArgs.ErrorLocus = OPOS_EL_INPUT_DATA Then 
			DialogMessage = "InputData Error" & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended)
			ErrorEventDlg.ErrorMessageLabel.Text = DialogMessage
			
			ErrorEventDlg.ErrorSuspendButton.Text = "Suspend Process"
			ErrorEventDlg.ErrorRetryButton.Text = "Continue Input"
			ErrorEventDlg.ErrorCancelButton.Text = "Clear"
			ErrorEventDlg.ErrorSuspendButton.Enabled = False
			ErrorEventDlg.ErrorRetryButton.Enabled = True
			ErrorEventDlg.ErrorCancelButton.Enabled = True
			
			VB6.ShowForm(ErrorEventDlg, 1, Me)
			
			If ErrorRecovery = 1 Then
				' Continue to receive input events.
				eventArgs.pErrorResponse = OPOS_ER_CONTINUEINPUT
			ElseIf ErrorRecovery = 0 Then 
				' Clear all input events.
				eventArgs.pErrorResponse = OPOS_ER_CLEAR
			End If
			
		ElseIf eventArgs.ErrorLocus = OPOS_EL_INPUT Then 
			DialogMessage = "Input Error" & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended)
			ErrorEventDlg.ErrorMessageLabel.Text = DialogMessage
			
			ErrorEventDlg.ErrorSuspendButton.Text = "Suspend Process"
			ErrorEventDlg.ErrorRetryButton.Text = "Continue Input"
			ErrorEventDlg.ErrorCancelButton.Text = "Clear"
			ErrorEventDlg.ErrorSuspendButton.Enabled = False
			ErrorEventDlg.ErrorRetryButton.Enabled = False
			ErrorEventDlg.ErrorCancelButton.Enabled = True
			
			VB6.ShowForm(ErrorEventDlg, 1, Me)
			
			' If ErrorLocus was OPOS_EL_INPUT, the event is Last input event.
			' ErrorResponse will unnecessary.
			
		End If
		
	End Sub
	
	Private Sub OPOSElectronicJournal1_OutputCompleteEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposElectronicJournal_CCO._IOPOSElectronicJournalEvents_OutputCompleteEventEvent) Handles OPOSElectronicJournal1.OutputCompleteEvent
		
		Dim DialogMessage As String
		DialogMessage = "Complete Printing Content File : ID = " & CStr(eventArgs.OutputID)
		
		Dim OutputCompleteEventDlg As New OutputCompleteEventDlg
		
		OutputCompleteEventDlg.Text = "EJSample_Step4"
		OutputCompleteEventDlg.OutputCompleteEventMessageLabel.Text = DialogMessage
		VB6.ShowForm(OutputCompleteEventDlg, 0, Me)
		
		CompareEJOutputID(eventArgs.OutputID)
		
	End Sub
	
	Private Sub CompareEJOutputID(ByVal OutputID As Integer)
		
		If OPOSElectronicJournal1.OutputID = OutputID Then
			EJAsyncPrinting = False
			SuspendPrintContentButton.Enabled = False
		End If
		
	End Sub
	
	Private Sub OPOSElectronicJournal1_StatusUpdateEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposElectronicJournal_CCO._IOPOSElectronicJournalEvents_StatusUpdateEventEvent) Handles OPOSElectronicJournal1.StatusUpdateEvent
		
		If eventArgs.Data = EJ_SUE_SUSPENDED Then
			'In suspend mode CancelPrintContent and ResumePrintContent are enabled.
			SuspendPrintContentButton.Enabled = False
			CancelPrintContentButton.Enabled = True
			ResumePrintContentButton.Enabled = True
			
		End If
		
		If eventArgs.Data = EJ_SUE_MEDIUM_NEAR_FULL Then
			MsgBox("ElectronicJournal Medium Near Full.", MsgBoxStyle.OKOnly, "EJSample_Step4")
		End If
		
	End Sub
	
	Private Sub OPOSPOSPrinter1_StatusUpdateEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_StatusUpdateEventEvent) Handles OPOSPOSPrinter1.StatusUpdateEvent
		
		' Enabled SuspendPrintContent button for replace receipt paper.
		If eventArgs.Data = PTR_SUE_REC_NEAREMPTY Then
			MsgBox("Receipt Station Paper Near End.", MsgBoxStyle.OKOnly, "EJSample_Step4")
			NearEndDetect = True
			If (OPOSElectronicJournal1.AsyncMode = True) And (EJAsyncPrinting = True) Then
				SuspendPrintContentButton.Enabled = True
			End If
			
		End If
		
		If eventArgs.Data = PTR_SUE_REC_PAPEROK Then
			NearEndDetect = False
		End If
		
	End Sub
	
	Private Sub PrintButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles PrintButton.Click
		
		' Print receipt by POSPrinter.
		' For detail refer POSPrinter SampleProgram.
		Dim rcSpacing As Integer
		Dim rcHeight As Integer
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1B)
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm")
		
		With OPOSPOSPrinter1
			rcSpacing = .RecLineSpacing
			rcHeight = .RecLineHeight
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_LEFT90)
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & ESC.Value & "|bC" & "   Receipt     ")
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|3C" & ESC.Value & "|2uC" & "       Mr. Brawn" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & "                                                  " & vbCrLf & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & ESC.Value & "|3C" & "        Total payment              $" & ESC.Value & "|4C" & "21.00  " & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, fDate & " Received" & vbCrLf & vbCrLf)
			.RecLineHeight = 24
			.RecLineSpacing = .RecLineHeight
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Details               " & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & "                          " & ESC.Value & "|2C" & "OPOS Store" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Tax excluded    $20.00" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1C" & "                          " & ESC.Value & "|bC" & "Zip code 999-9999" & vbCrLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|uC" & " Tax(5%)        $1.00" & ESC.Value & "|N" & "    Phone#(9999)99-9998" & vbCrLf)
			
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_NORMAL)
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|fP")
			
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
			
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Receipt print. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
			
			.RecLineSpacing = rcSpacing
			.RecLineHeight = rcHeight
		End With
		
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	
	
	Private Sub PrintContentFileButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles PrintContentFileButton.Click
		
		' Print ElectronicJournal file that extracted storage.
		With OPOSElectronicJournal1
			.PrintContentFile(PrintFileNameEdit.Text)
			
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Print ElectronicJournalFile. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
				
			End If
			
			If (.AsyncMode = True) Then
				EJAsyncPrinting = True
			End If
			If (EJAsyncPrinting = True) And (.ResultCode = OPOS_SUCCESS) And (NearEndDetect = True) Then
				SuspendPrintContentButton.Enabled = True
			End If
			
		End With
		
	End Sub
	
	Private Sub QueryContentButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles QueryContentButton.Click
		
		With OPOSElectronicJournal1
			.QueryContent(FileNameEdit.Text, StartMarkerEdit.Text, EndMarkerEdit.Text)
			
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Create ElectronicJournalFile. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
		End With
		
	End Sub
	
	Private Sub ResumePrintContentButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles ResumePrintContentButton.Click
		
		' Extract storage content by from marker to marker.
		With OPOSElectronicJournal1
			.ResumePrintContent()
			
			If .ResultCode = OPOS_SUCCESS Then
				' SuspendMode end.
				ResumePrintContentButton.Enabled = False
				CancelPrintContentButton.Enabled = False
				SuspendPrintContentButton.Enabled = True
				
			Else
				MsgBox("Failed to Resume print." & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
				
			End If
		End With
		
	End Sub
	
	Private Sub StorageEnabledCheck_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles StorageEnabledCheck.CheckStateChanged
		
		' ElectronicJournal storage Start / Stop
		Dim CheckBoxValue As Short
		With OPOSElectronicJournal1
			.StorageEnabled = StorageEnabledCheck.CheckState
			
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Failed to Storage Ready. " & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
			End If
			
			
			If .StorageEnabled Then
				CheckBoxValue = 1
			Else
				CheckBoxValue = 0
			End If
			
			StorageEnabledCheck.CheckState = CheckBoxValue
			
		End With
	End Sub
	
	Private Sub SuspendPrintContentButton_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles SuspendPrintContentButton.Click
		
		' ElectronicJournal storage Start / Stop
		With OPOSElectronicJournal1
			.SuspendPrintContent()
			
			If .ResultCode = OPOS_SUCCESS Then
				SuspendPrintContentButton.Enabled = False
				
			Else
				MsgBox("Failed to Suspend print." & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended))
				
			End If
			
		End With
	End Sub
End Class