Option Strict Off
Option Explicit On
Friend Class Step7
	Inherits System.Windows.Forms.Form
	' Step 7  Use the asynchronous outputting
	
	Private Structure ITEMDATA
		Dim Name_Renamed As String
		Dim Price As Integer
	End Structure
	
	Private Function MakePrintString(ByRef lRecLineChars As Integer, ByRef sBuf As String, ByRef sPrice As String) As Object
		Dim sValue As String
		If lRecLineChars < (Len(sBuf) + Len(sPrice)) Then
			sValue = sBuf & sPrice
		Else
			sValue = sBuf & Space(lRecLineChars - (Len(sBuf) + Len(sPrice))) & sPrice
		End If
		
		MakePrintString = sValue
	End Function
	
	Private Sub cmdPrint_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrint.Click
		
		Dim lValue As Integer
		Dim i As Short
		Dim idBuf(5) As ITEMDATA
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		Dim BcData As String
		Dim sBuf As String
		Dim sPrice As String
		Dim sValue As String
		Dim sRecLineChars() As String
		Dim lRecLineCharsCount As Integer
		
		' When outputting to a printer,a mouse cursor becomes like a hourglass.
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		
		ESC.Value = Chr(&H1Bs)
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm")
		BcData = "4902720005074"
		
		' Make a data of the buying goods
		idBuf(0).Name_Renamed = "apples" : idBuf(0).Price = 10
		idBuf(1).Name_Renamed = "grapes" : idBuf(1).Price = 20
		idBuf(2).Name_Renamed = "bananas" : idBuf(2).Price = 30
		idBuf(3).Name_Renamed = "lemons" : idBuf(3).Price = 40
		idBuf(4).Name_Renamed = "oranges" : idBuf(4).Price = 50
		
		With OPOSPOSPrinter1
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1B")
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & "123xxstreet,xxxcity,xxxxstate " & vbLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|rA" & "TEL 9999-99-9999   C#2" & vbLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
			
			'Change of the font size
			lRecLineCharsCount = GetRecLineChars(sRecLineChars)
			If lRecLineCharsCount >= 2 Then
				.RecLineChars = CInt(sRecLineChars(1))
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|cA" & fDate & vbLf)
				.RecLineChars = CInt(sRecLineChars(0))
			Else
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|cA" & fDate & vbLf)
			End If
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|500uF")
			'Print buying goods
			lValue = 0
			For i = LBound(idBuf) To UBound(idBuf) - 1
				If .ResultCode <> OPOS_SUCCESS Then Exit For
				sBuf = idBuf(i).Name_Renamed
				lValue = lValue + idBuf(i).Price
				sPrice = VB6.Format(idBuf(i).Price, "$#.00")
				sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, sValue & vbLf)
			Next 
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
			'Print the total cost
			sBuf = "Tax excluded."
			sPrice = VB6.Format(lValue, "$#.00")
			sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|bC" & sValue & vbLf)
			sBuf = "Tax  5.0%"
			sPrice = VB6.Format(lValue * 0.05, "$#.00")
			sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|uC" & sValue & vbLf)
			sBuf = "Total"
			sPrice = VB6.Format(lValue * 1.05, "$#.00")
			sValue = MakePrintString(.RecLineChars \ 2, sBuf, sPrice) 'Because the width of characters of total is doubled, take this into consideration when computing.
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|bC" & ESC.Value & "|2C" & sValue & vbLf)
			sBuf = "Customer's payment"
			sPrice = VB6.Format(200, "$#.00")
			sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & sValue & vbLf)
			sBuf = "Change"
			sPrice = VB6.Format(200 - lValue * 1.05, "$#.00")
			sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
			.PrintNormal(PTR_S_RECEIPT, sValue & vbLf)
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|500uF")
			.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_JAN13, 1000, .RecLineWidth, PTR_BC_CENTER, PTR_BC_TEXT_BELOW)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|fP")
			
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
		End With
		
		' When a cursor is back to its default shape, it means the process ends.
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	Private Function GetRecLineChars(ByRef sRecLineChars() As String) As Object
		Dim lIndex As Integer
		Dim lCount As Integer
		Dim sRecLineCharsList As String
		Dim i As Short
		Dim lStartIndex As Integer
		Dim lEndIndex As Integer
		
		
		sRecLineCharsList = OPOSPOSPrinter1.RecLineCharsList
		
		If Len(sRecLineCharsList) = 0 Then
			GetRecLineChars = 0
		Else
			'Calculate the element count.
			lCount = 1
			lIndex = InStr(1, sRecLineCharsList, ",")
			While lIndex <> 0
				lCount = lCount + 1
				lIndex = lIndex + 1
				lIndex = InStr(lIndex, sRecLineCharsList, ",")
			End While
			
			'Set the element to array.
			ReDim sRecLineChars(lCount)
			
			lStartIndex = 1
			For i = 0 To lCount - 1
				lEndIndex = InStr(lStartIndex, sRecLineCharsList, ",")
				If lEndIndex = 0 Then
					lEndIndex = Len(sRecLineCharsList)
				End If
				
				sRecLineChars(i) = Mid(sRecLineCharsList, lStartIndex, lEndIndex - 1)
				lStartIndex = lEndIndex + 1
			Next 
			
			GetRecLineChars = lCount
			
		End If
		
	End Function
	
	Private Sub cmdAsync_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdAsync.Click
		
		Dim lValue As Integer
		Dim i As Short
		Dim idBuf(4) As ITEMDATA
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		Dim BcData As String
		Dim sBuf As String
		Dim sPrice As String
		Dim sValue As String
		
		' When outputting to a printer,a mouse cursor becomes like a hourglass.
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		
		ESC.Value = Chr(&H1Bs)
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm")
		BcData = "4902720005074"
		
		' Make a data of the buying goods
		idBuf(0).Name_Renamed = "apples" : idBuf(0).Price = 10
		idBuf(1).Name_Renamed = "grapes" : idBuf(1).Price = 20
		idBuf(2).Name_Renamed = "bananas" : idBuf(2).Price = 30
		idBuf(3).Name_Renamed = "lemons" : idBuf(3).Price = 40
		idBuf(4).Name_Renamed = "oranges" : idBuf(4).Price = 50
		
		With OPOSPOSPrinter1
			'Afterwards, asynchronous output
			.AsyncMode = True
			
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1B")
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & "123xxstreet,xxxcity,xxxxstate " & vbLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|rA" & "TEL 9999-99-9999   C#2" & vbLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|cA" & fDate & vbLf)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|500uF")
			'Print buying goods
			lValue = 0
			For i = LBound(idBuf) To UBound(idBuf)
				If .ResultCode <> OPOS_SUCCESS Then Exit For
				sBuf = idBuf(i).Name_Renamed
				lValue = lValue + idBuf(i).Price
				sPrice = VB6.Format(idBuf(i).Price, "$#.00")
				sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
				.PrintNormal(PTR_S_RECEIPT, sValue & vbLf)
			Next 
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
			'Print the total cost
			sBuf = "Tax excluded."
			sPrice = VB6.Format(lValue, "$#.00")
			sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|bC" & sValue & vbLf)
			sBuf = "Tax  5.0%"
			sPrice = VB6.Format(lValue * 0.05, "$#.00")
			sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|uC" & sValue & vbLf)
			sBuf = "Total"
			sPrice = VB6.Format(lValue * 1.05, "$#.00")
			sValue = MakePrintString(.RecLineChars \ 2, sBuf, sPrice) 'Because the width of characters of total is doubled, take this into consideration when computing.
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|bC" & ESC.Value & "|2C" & sValue & vbLf)
			sBuf = "Customer's payment"
			sPrice = VB6.Format(200, "$#.00")
			sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & sValue & vbLf)
			sBuf = "Change"
			sPrice = VB6.Format(200 - lValue * 1.05, "$#.00")
			sValue = MakePrintString(.RecLineChars, sBuf, sPrice)
			.PrintNormal(PTR_S_RECEIPT, sValue & vbLf)
			
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|500uF")
			.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_JAN13, 1000, .RecLineWidth, PTR_BC_CENTER, PTR_BC_TEXT_BELOW)
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|fP")
			
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
			
			'Back to the synchronous mode
			.AsyncMode = False
		End With
		
		' When a cursor is back to its default shape, it means the process ends.
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	Private Sub OPOSPOSPrinter1_OutputCompleteEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_OutputCompleteEventEvent) Handles OPOSPOSPrinter1.OutputCompleteEvent
		
		'Notify that printing is completed when it is asnchronous.
		MsgBox("Complete printing", MsgBoxStyle.Information)
		
	End Sub
	
	Private Sub Step7_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSPOSPrinter1
			.Open("Unit1")
			.ClaimDevice(1000)
			.DeviceEnabled = True
			
			.MapMode = PTR_MM_METRIC
			.RecLetterQuality = True
			
			.SetBitmap(1, PTR_S_RECEIPT, My.Application.Info.DirectoryPath & "\Logo.bmp", .RecLineWidth / 2, PTR_BM_CENTER)
		End With
		
	End Sub
	
	
	Private Sub Step7_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSPOSPrinter1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
End Class