
// FullColorDisplayDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FullColorDisplay.h"
#include "FullColorDisplayDlg.h"
#include "afxdialogex.h"

#include "OPOS.h"
#include "OPOSDisp.h"
#include "EPSNDisp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CFullColorDisplayDlg dialog

CFullColorDisplayDlg::CFullColorDisplayDlg(CWnd* pParent /*=NULL*/)
  : CDialogEx(CFullColorDisplayDlg::IDD, pParent)
{
  m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
  m_bIsLandscape = FALSE;
}

void CFullColorDisplayDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialogEx::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_LINEDISPLAY1, m_Disp1);
}

BEGIN_MESSAGE_MAP(CFullColorDisplayDlg, CDialogEx)
  ON_WM_SYSCOMMAND()
  ON_WM_PAINT()
  ON_WM_QUERYDRAGICON()
  ON_BN_CLICKED(IDC_BUTTON_LANDSCAPE, &CFullColorDisplayDlg::OnBnClickedButtonLandscape)
  ON_BN_CLICKED(IDC_BUTTON_PORTRAIT, &CFullColorDisplayDlg::OnBnClickedButtonPortrait)
  ON_BN_CLICKED(IDC_BUTTON_ORDER, &CFullColorDisplayDlg::OnBnClickedButtonOrder)
  ON_BN_CLICKED(IDC_BUTTON_CHECK, &CFullColorDisplayDlg::OnBnClickedButtonCheck)
  ON_BN_CLICKED(IDC_BUTTON_START, &CFullColorDisplayDlg::OnBnClickedButtonStart)
  ON_BN_CLICKED(IDC_BUTTON_STOP, &CFullColorDisplayDlg::OnBnClickedButtonStop)
END_MESSAGE_MAP()


// CFullColorDisplayDlg message handlers

BOOL CFullColorDisplayDlg::OnInitDialog()
{
  CDialogEx::OnInitDialog();

  // Set the icon for this dialog.  The framework does this automatically
  //  when the application's main window is not a dialog
  SetIcon(m_hIcon, TRUE);      // Set big icon
  SetIcon(m_hIcon, FALSE);    // Set small icon

  // TODO: Add extra initialization here
  try {
    //Open the device
    //Use a Logical Device Name which has been set on the SetupPOS.
    m_Disp1.Open(_T("Unit1"));
    //Check whether the device is succeed to open, or not
    if( m_Disp1.get_ResultCode() != OPOS_SUCCESS ) {
      MessageBox(_T("This device has not been registered, or cannot use."));
      throw -1;
    }

    //Get the exclusive control right for the opened device.
    //Then the device is disable from other application.
    //(Notice:When using an old CO, use the Claim.)
    m_Disp1.ClaimDevice( 1000 );
    if( m_Disp1.get_ResultCode() != OPOS_SUCCESS ) {
      MessageBox(_T("Fails to get the exclusive right for the device."));
      throw -1;
    }

    //If support the CapPowerReporting, 
    //enable the Power Reporting Requirements.
    if( m_Disp1.get_CapPowerReporting() != OPOS_PR_NONE ){
      m_Disp1.put_PowerNotify( OPOS_PN_ENABLED );
    }

    //Enable the device.
    m_Disp1.put_DeviceEnabled( TRUE );
    //Check whether the device is enable to use, or not
    if( m_Disp1.get_ResultCode() != OPOS_SUCCESS ) {
      MessageBox(_T("Now the device is disable to use."));
      throw -1;
    }

    // Initialize layout
    m_bIsLandscape = TRUE;
    long pData = DISP_DI_DUMMY;
    BSTR pString = SysAllocString(_T(""));

    // Layout No:25(Upper: image, Lower: text)
    pData = 25;
    m_Disp1.DirectIO(DISP_DI_LAYOUT, &pData, &pString);

    // Create a 5x17 window(Background color: White)
    m_Disp1.CreateWindow0(0, 0, 5, 17, 5, 17);
    pData = DISP_DI_WHITE;
    m_Disp1.DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, &pData, &pString);

    // Creata a 5x16 window from row: 0 column: 18(Background color: Cyan)
    m_Disp1.CreateWindow0(0, 17, 5, 16, 5, 16);
    pData = DISP_DI_CYAN;
    m_Disp1.DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, &pData, &pString);

    // Start slideshow
    pData = DISP_DI_SLIDESHOW_START;
    m_Disp1.DirectIO(DISP_DI_SLIDESHOW, &pData, &pString);

    // Regster image files on Display
    CString strData;

    pData = 1;
    strData = _T(".\\ThankE800.png");
    pString = strData.AllocSysString();
    m_Disp1.DirectIO(DISP_DI_REGISTER_IMAGE, &pData, &pString);

    pData = 2;
    strData = _T(".\\ThankE.png");
    pString = strData.AllocSysString();
    m_Disp1.DirectIO(DISP_DI_REGISTER_IMAGE, &pData, &pString);

    SysFreeString(pString);

  } catch(...){
    GetDlgItem(IDC_BUTTON_LANDSCAPE)->EnableWindow(FALSE);
    GetDlgItem(IDC_BUTTON_PORTRAIT)->EnableWindow(FALSE);
    GetDlgItem(IDC_BUTTON_ORDER)->EnableWindow(FALSE);
    GetDlgItem(IDC_BUTTON_CHECK)->EnableWindow(FALSE);
    GetDlgItem(IDC_BUTTON_START)->EnableWindow(FALSE);
    GetDlgItem(IDC_BUTTON_STOP)->EnableWindow(FALSE);
  }

  return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFullColorDisplayDlg::OnPaint()
{
  if (IsIconic())
  {
    CPaintDC dc(this); // device context for painting

    SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

    // Center icon in client rectangle
    int cxIcon = GetSystemMetrics(SM_CXICON);
    int cyIcon = GetSystemMetrics(SM_CYICON);
    CRect rect;
    GetClientRect(&rect);
    int x = (rect.Width() - cxIcon + 1) / 2;
    int y = (rect.Height() - cyIcon + 1) / 2;

    // Draw the icon
    dc.DrawIcon(x, y, m_hIcon);
  }
  else
  {
    CDialogEx::OnPaint();
  }
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFullColorDisplayDlg::OnQueryDragIcon()
{
  return static_cast<HCURSOR>(m_hIcon);
}


void CFullColorDisplayDlg::OnBnClickedButtonLandscape()
{

  m_bIsLandscape = TRUE;
  long pData = DISP_DI_DUMMY;
  BSTR pString = SysAllocString(_T(""));

  // Clear displayed image
  m_Disp1.DirectIO(DISP_DI_CLEAR_IMAGE, &pData, &pString);

  // Clear displayed barcode
  m_Disp1.DirectIO(DISP_DI_CLEAR_BARCODE, &pData, &pString);

  // Delete all window
  m_Disp1.put_CurrentWindow(1);
  m_Disp1.DestroyWindow0();
  m_Disp1.put_CurrentWindow(2);
  m_Disp1.DestroyWindow0();

  // Layout No:25(Upper: image, Lower: text)
  pData = 25;
  m_Disp1.DirectIO(DISP_DI_LAYOUT, &pData, &pString);

  // Create a 5x17 window(Background color: White)
  m_Disp1.CreateWindow0(0, 0, 5, 17, 5, 17);
  pData = DISP_DI_WHITE;
  m_Disp1.DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, &pData, &pString);

  // Creata a 5x16 window from row: 0 column: 18(Background color: Cyan)
  m_Disp1.CreateWindow0(0, 17, 5, 16, 5, 16);
  pData = DISP_DI_CYAN;
  m_Disp1.DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, &pData, &pString);

  // Start slideshow
  pData = DISP_DI_SLIDESHOW_START;
  m_Disp1.DirectIO(DISP_DI_SLIDESHOW, &pData, &pString);

  SysFreeString(pString);

}


void CFullColorDisplayDlg::OnBnClickedButtonPortrait()
{

  m_bIsLandscape = FALSE;
  long pData = DISP_DI_DUMMY;
  BSTR pString = SysAllocString(_T(""));

  // Clear displayed image
  m_Disp1.DirectIO(DISP_DI_CLEAR_IMAGE, &pData, &pString);

  // Clear displayed barcode
  m_Disp1.DirectIO(DISP_DI_CLEAR_BARCODE, &pData, &pString);

  // Delete all window
  m_Disp1.put_CurrentWindow(1);
  m_Disp1.DestroyWindow0();
  m_Disp1.put_CurrentWindow(2);
  m_Disp1.DestroyWindow0();

  // Layout No:27(Upper: image, Lower: text)
  pData = 27;
  m_Disp1.DirectIO(DISP_DI_LAYOUT, &pData, &pString);

  // Create a 3x20 window(Background color: Cyan)
  m_Disp1.CreateWindow0(0, 0, 3, 20, 3, 20);
  pData = DISP_DI_CYAN;
  m_Disp1.DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, &pData, &pString);

  // Create a 5x5 window(Background color: White)
  m_Disp1.CreateWindow0(3, 0, 5, 20, 5, 20);
  pData = DISP_DI_WHITE;
  m_Disp1.DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, &pData, &pString);

  // Start slideshow
  pData = DISP_DI_SLIDESHOW_START;
  m_Disp1.DirectIO(DISP_DI_SLIDESHOW, &pData, &pString);

  SysFreeString(pString);
}


void CFullColorDisplayDlg::OnBnClickedButtonOrder()
{

  long pData = DISP_DI_DUMMY;
  BSTR pString = SysAllocString(_T(""));

  // Clear displayed barcode
  m_Disp1.DirectIO(DISP_DI_CLEAR_BARCODE, &pData, &pString);

  // When the slide show is not running, the slide show starts after the image is erased
  // Clear displayed image
  m_Disp1.DirectIO(DISP_DI_CLEAR_IMAGE, &pData, &pString);

  // Start slideshow
  pData = DISP_DI_SLIDESHOW_START;
  m_Disp1.DirectIO(DISP_DI_SLIDESHOW, &pData, &pString);

  if(m_bIsLandscape) {
    m_Disp1.put_CurrentWindow(1);
    m_Disp1.ClearText();

    // Set the specified character color
    pData = DISP_DI_BLACK;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("Item:\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("  Cut & Sewn\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("U.PC.45.00->"), DISP_DT_NORMAL);

    // Set the specified character color
    pData = DISP_DI_RED;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("22.50\n"), DISP_DT_NORMAL);

    // Set the specified character color
    pData = DISP_DI_BLACK;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("QTY:            3"), DISP_DT_NORMAL);
    
    m_Disp1.put_CurrentWindow(2);
    m_Disp1.ClearText();

    // Set the specified character color
    pData = DISP_DI_BLACK;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("SubTotal:\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("         $66.50\n"), DISP_DT_NORMAL);

  }
  else {
    m_Disp1.put_CurrentWindow(1);
    m_Disp1.ClearText();

    // Set the specified character color
    pData = DISP_DI_BLACK;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("Item:\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("  Cut & Sewn\n"), DISP_DT_NORMAL);

    m_Disp1.put_CurrentWindow(2);
    m_Disp1.ClearText();

    // Set the specified character color
    pData = DISP_DI_BLACK;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("Qty:              3\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("U.PC.:       $45.00\n"), DISP_DT_NORMAL);

    // Set the specified character color
    pData = DISP_DI_RED;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("             (22.50)\n"), DISP_DT_NORMAL);

    // Set the specified character color
    pData = DISP_DI_BLACK;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("SubTotal:    $67.50"), DISP_DT_NORMAL);

  }
  SysFreeString(pString);
}


void CFullColorDisplayDlg::OnBnClickedButtonCheck()
{

  long pData = DISP_DI_DUMMY;
  BSTR pString = SysAllocString(_T(""));
  CString strData;

  // Stop slideshow
  pData = DISP_DI_SLIDESHOW_STOP;
  m_Disp1.DirectIO(DISP_DI_SLIDESHOW, &pData, &pString);


  if(m_bIsLandscape) {
    // Display registered image
    pData = 1;
    strData = _T("0, 0, 800, 240");
    pString = strData.AllocSysString();
    m_Disp1.DirectIO(DISP_DI_DISPLAY_IMAGE, &pData, &pString);

    m_Disp1.put_CurrentWindow(1);
    m_Disp1.ClearText();

    // Set the specified character color
    pData = DISP_DI_BLACK;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("Store Infomation\n"), DISP_DT_NORMAL);
    
    m_Disp1.put_CurrentWindow(2);
    m_Disp1.ClearText();

    // Set the specified character color
    pData = DISP_DI_BLACK;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("Total:   $66.50\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("Cash:   $100.50\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("Change:  $34.00"), DISP_DT_NORMAL);

    pData = DISP_DI_QRCODE_MODEL_2;
    strData = _T("https://www.epson-pos.com/");
    pString = strData.AllocSysString();
    // Register barcode data
    m_Disp1.DirectIO(DISP_DI_SET_BARCODE_DATA, &pData, &pString);

    strData = _T("120,70,4");
    pString = strData.AllocSysString();
    // Display registered barcode data
    m_Disp1.DirectIO(DISP_DI_DISPLAY_BARCODE, &pData, &pString);

  }
  else {
    // Display registered image
    pData = 2;
    strData = _T("0,0,480,400");
    pString = strData.AllocSysString();
    m_Disp1.DirectIO(DISP_DI_DISPLAY_IMAGE, &pData, &pString);

    m_Disp1.put_CurrentWindow(1);
    m_Disp1.ClearText();

    // Set the specified character color
    pData = DISP_DI_BLACK;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayText(_T("Total:        $67.50\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("Cash:        $100.00\n"), DISP_DT_NORMAL);
    m_Disp1.DisplayText(_T("Change:       $32.50"), DISP_DT_NORMAL);
    
    m_Disp1.put_CurrentWindow(2);
    m_Disp1.ClearText();

    // Set the specified character color
    pData = DISP_DI_BLACK;
    m_Disp1.DirectIO(DISP_DI_SET_TEXT_COLOR, &pData, &pString);
    m_Disp1.DisplayTextAt(1, 1, _T("Store Information\n"), DISP_DT_NORMAL);

    pData = DISP_DI_QRCODE_MODEL_2;
    strData = _T("https://www.epson-pos.com/");
    pString = strData.AllocSysString();
    // Register barcode data
    m_Disp1.DirectIO(DISP_DI_SET_BARCODE_DATA, &pData, &pString);

    strData = _T("160,260,4");
    pString = strData.AllocSysString();
    // Display registered barcode data
    m_Disp1.DirectIO(DISP_DI_DISPLAY_BARCODE, &pData, &pString);
  }
  SysFreeString(pString);
}


void CFullColorDisplayDlg::OnBnClickedButtonStart()
{
  // The SlideShow function works by pre-registering the images using utility
  long pData = DISP_DI_DUMMY;
  BSTR pString = SysAllocString(_T(""));

  // Clear displayed image
  m_Disp1.DirectIO(DISP_DI_CLEAR_IMAGE, &pData, &pString);

  // Start slideshow
  pData = DISP_DI_SLIDESHOW_START;
  m_Disp1.DirectIO(DISP_DI_SLIDESHOW, &pData, &pString);

  SysFreeString(pString);
}


void CFullColorDisplayDlg::OnBnClickedButtonStop()
{
  // Stop slideshow
  long pData = DISP_DI_SLIDESHOW_STOP;
  BSTR pString = SysAllocString(_T(""));

  m_Disp1.DirectIO(DISP_DI_SLIDESHOW, &pData, &pString);
  SysFreeString(pString);
}


BOOL CFullColorDisplayDlg::DestroyWindow()
{
  //Cancel the device
  m_Disp1.put_DeviceEnabled( FALSE );

  //Release the device exclusive control right.
  //(Notice:When using an old CO, use the Release.)
  m_Disp1.ReleaseDevice();

  //Finish using the device.
  m_Disp1.Close();

  return CDialogEx::DestroyWindow();
}


BEGIN_EVENTSINK_MAP(CFullColorDisplayDlg, CDialogEx)
  ON_EVENT(CFullColorDisplayDlg, IDC_LINEDISPLAY1, 5, CFullColorDisplayDlg::StatusUpdateEventLinedisplay1, VTS_I4)
END_EVENTSINK_MAP()


void CFullColorDisplayDlg::StatusUpdateEventLinedisplay1(long Data)
{
  //The Power Reporting Requirements fires the event when the device power status is changed.
  switch( Data ) {
    case OPOS_SUE_POWER_ONLINE:         // The device is powered on.
      MessageBox(_T("The device is powered on."));
      break;
      case OPOS_SUE_POWER_OFF:          // The device is powered off, or unconnected.
      MessageBox(_T("The device is powered off, or unconnected."));
    break;
      case OPOS_SUE_POWER_OFFLINE:      // The device is powered on, but disable to operate.
      MessageBox(_T("The device is powered on, but disable to operate."));
    break;
      case OPOS_SUE_POWER_OFF_OFFLINE:  // The device is powered off or off-line.
      MessageBox(_T("The device is powered on or off-line."));
    break;
  }
}
